#!/bin/sh

##########################################################################
#
#
#  Example: ./config.sh /path/filename

#
##########################################################################


#
# Example of what should be passed to the routine
#

usage() {

    echo " "
    echo " ${0} [File Name]" 
    echo " "
    echo -e "File Name   - E.g. path/filename"
   
    exit 1

} # end of usage()

#
#  Validate that file name is passed in
#

if [ "$1" = "" ]; then
    echo "ERROR - Missing parameter"
       usage
fi

#
# Assign the file name 
# 

FILE_NAME=$1

#
#copy the file to /etc/hp-snmp-agents.conf
#
cp $FILE_NAME /etc/hp-snmp-agents.conf
#
#source the file
#
source $FILE_NAME

#
#run the hpsnmpconfig tool and restart all the daemons
#
f [ -x /sbin/hpsnmpconfig ]; then
  echo Activating HP Agents...
  /sbin/hpsnmpconfig
  #service hp-ilo restart
  service hp-health restart
  service hp-snmp-agents restart
  service hpsmhd restart
fi

